#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Sphere ReflectionsMod01.fsh  by rooby 
//https://www.shadertoy.com/view/ssGfzy
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define MAX_STEPS 255
#define MAX_DIST 100.
#define MIN_DIST 0.0001

#define PI 3.14159

const vec3 SUN_DIR = normalize(vec3(2., 0.5, 3.));

const vec3 SUN_COL = vec3(1.64, 1.27, 0.99);
const vec3 SKY_COL = vec3(0.16, 0.20, 0.28);
const vec3 IND_COL = vec3(0.40, 0.28, 0.20);

const vec3 FOG_COL = vec3(0.5, 0.6, 0.7);

// Return 2D rotation matrix of angle a
mat2 rot(float a)
{
    return mat2(cos(a), -sin(a), sin(a), cos(a));
}

// polynomial smooth min
float smin( float a, float b, float k )
{
    float h = max( k-abs(a-b), 0.0 )/k;
    return min( a, b ) - h*h*k*(1.0/4.0);
}

// Check if the given material is reflective
bool isReflective(int mat_type)
{
    return mat_type == 0;
}

// Return the material color at the given position in the scene
vec3 getMaterial(vec3 pos, vec3 normal, int mat_type)
{
    vec3 mat;
    
    if (mat_type == 0)
        mat = 0.8*vec3(0.16, 0.24, 0.33);
    else if (mat_type == 1)
    {
        vec3 center = vec3(round(pos.xy/5.)*5., 0);
        int i = int(100.*(1.+sin(5.*(center.x*center.y)))) % 5;
    
        if (i == 0)
            mat = vec3(0.82, 0.08, 0.12);
        else if (i == 1)
            mat = vec3(0.7, 0.7, 0.05);
        else if (i == 2)
            mat = vec3(0.65, 0.15, 0.75);
        else if (i == 3)
            mat = vec3(0.12, 0.8, 0.1);
        else if (i == 4)
            mat = vec3(0.05, 0.2, 0.9);
    }
    
    return mat;
}

// Return signed distance to nearest object in the scene
// along with the material type of that object
vec2 scene(vec3 pos)
{
    float d;
    int mat_type = 0;

    vec3 center = vec3(round(pos.xy/5.)*5., 0);

    float radius = 1. + 0.5*sin(7.*(center.x+center.y));
    float d_sphere = length(pos - center + vec3(0, 0, 1. - radius)) - radius;
    
    float d_ground = pos.z + 1.;
    
    d = smin(d_sphere, d_ground, 0.05);
    
    if (d == d_sphere)
        mat_type = 1;

    return vec2(d, mat_type);
}

// Return the normal vector to the scene at the given position pos
vec3 getNormal(vec3 pos)
{
    vec2 u = vec2(0.0001, 0);
    return normalize(vec3(scene(pos + u.xyy).x - scene(pos - u.xyy).x,
                          scene(pos + u.yxy).x - scene(pos - u.yxy).x,
                          scene(pos + u.yyx).x - scene(pos - u.yyx).x));
}

// Standard raymarching function
// Returns depth from rayOrigin along rayDir to closet object,
// along with material type and soft shadow factor
vec3 rayMarch(vec3 rayOrigin, vec3 rayDir)
{
    float depth = 0.003;
    float shadow = 1.;
    float ph = 1e20;

    for (int i=0; i<MAX_STEPS; i++)
    {
        vec3 pos = rayOrigin + depth*rayDir;
        vec2 dist = scene(pos);
        
        depth += dist.x;
        
        float y = dist.x*dist.x/(2.0*ph);
        float d = sqrt(dist.x*dist.x-y*y);
        shadow = min(shadow, 8.*d/max(0.0,depth-y) );
        
        if (depth > MAX_DIST) break;
        if (abs(dist.x) < MIN_DIST) return vec3(depth, dist.y, shadow);
    }
    
    return vec3(-1, 0, shadow);
}

// Return color at given position
vec3 getColor(vec3 pos, vec3 normal, int mat_type)
{
    vec3 mat = getMaterial(pos, normal, mat_type);
    
    // Intensities of different light sources
    float sun_int = clamp(dot(normal, SUN_DIR), 0., 1.);
    float sky_int = clamp(0.5 + 0.5*normal.z, 0., 1.);
    float ind_int = clamp(dot(normal, normalize(vec3(-SUN_DIR.xy, 0))), 0., 1.);
    
    // Do shadow
    vec3 d = rayMarch(pos + 0.003*normal, SUN_DIR);
    float sha = d.z;
    
    // Add lighting
    vec3 lighting = sha*sun_int*SUN_COL + sky_int*SKY_COL + ind_int*IND_COL;
    vec3 col = lighting * mat;
    
    return col;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{

    // Normalized pixel coordinates
    vec2 uv = 2.*(fragCoord - .5*iResolution.xy) / iResolution.y;

    // Camera origin and direction
    vec3 rayOrigin = vec3(0, -3, 0);
    vec3 rayDir = normalize(vec3(uv.x, 1, uv.y));
    
    // Camera rotation
    mat2 rot_mat = rot(0.2*iTime);
    rayOrigin += vec3(2.5*sin(iTime/5.*PI), iTime, 0);
    rayDir = vec3(rot_mat*rayDir.xy, rayDir.z);

    // Do raymarching
    vec3 d = rayMarch(rayOrigin, rayDir);
    float depth = d.x;
    int mat_type = int(d.y);
    vec3 pos = rayOrigin + depth*rayDir;
    
    vec3 col = (1.5 - 0.5*exp(0.35*uv.y)) * vec3(0.09, 0.4, 1.2); // Sky color
    
    // If object hit, render it
    if (depth > 0.)
    {
        vec3 normal = getNormal(pos);
        col = vec3(0.);
        
        // Reflect object
        if (isReflective(mat_type))
        {
            vec3 ref = normalize(reflect(rayDir, normal));
            vec3 ref_d = rayMarch(pos + 0.003*normal, ref);
            float ref_depth = ref_d.x; int ref_mat_type = int(ref_d.y);
            vec3 ref_pos = pos + ref_depth*ref;
            vec3 ref_normal = getNormal(ref_pos);
            
            if (ref_depth > 0.)
                col = 0.35*getColor(ref_pos, ref_normal, ref_mat_type);
        }
        
        col += getColor(pos, normal, mat_type);
        
        // Apply fog
        float fog_int = 1. - exp(-depth*0.02);
        col = mix(col, FOG_COL, fog_int);
    }

    // Gamma correction
    col = pow(col, vec3(1./2.2));

    // Output to screen
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

